<?php
  /* ------------ Required Includes ------------ */
   // JSON is used to serialise the profile data in the cookie.
   // This gives us the benefit of having a neat cookie that
   // can be edited/viewed from javascript and php. 
  require_once('ssojson.php');
  /* ------------------------------------------- */

  function fetchProfile($key)  {

    /* ----------- Fetch SMS Profile ------------- */
  	$sec      = crypt(substr($key,0,8), 'PE');
  	$response = file_get_contents(SMS_SSO_PROFILE_URL."?key=$key&sec=$sec&siteid=".SMSSITEID);
    /* ------------------------------------------- */
  	
  	/* 
  	   For some unknown reason no DOM or SimpleXML support is avaiable on places[dev/web]
  	   When it is, uncomment this to have a much more maintainable
  	   SMS Authentication solution.
  	*/

  	/*
    $profile  = array();
  	$response = simplexml_load_string($response);

    // For the time being send the user to the no database page
    // In the future we could write handlers based on the ReasonCode
    if(!isset($response->AcceptSubscription)) {
  	  header("Location: ".NODBPAGE);
      exit;
    }

  	// Build User Profile (see the response xml for other data you might want)
    $profile['id']              = $response->AcceptSubscription->User['id'];
    $profile['FirstName']       = $response->AcceptSubscription->User->FirstName;
    $profile['LastName']        = $response->AcceptSubscription->User->LastName;
    $profile['LoginName']       = $response->AcceptSubscription->User->LoginName;
    $profile['EmailAddress']    = $response->AcceptSubscription->User->EmailAddress;
    $profile['InstitutionName'] = $response->AcceptSubscription->User->InstitutionName;
    $profile['secret']          = SECRET;

    foreach ($response->AcceptSubscription->Module as $module) {
       if($module->ModuleAbbrev == SMSMODULEABBREV)  {
         $profile['isTrial']                       = $module['isTrial'];
         $profile['isExpiringWithinWarningPeriod'] = $module['isExpiringWithinWarningPeriod'];
         $profile['isExpired']                     = $module['isExpired'];
         $profile['LastSignOnDate']                = $module->LastSignOnDate;
         $profile['ExpirationDate']                = $module->ExpirationDate;
         $profile['ProductRoleName']               = $module->ProductRoleName;
       }
    }
    */

    /*
      In the mean time we must use this confusing code and pray SMSAuthResponse
      doesn't change.
    */

    /* -------------- Confusing code ------------- */  
    $profile  = array();
  	$myparser = xml_parser_create();
  	xml_parse_into_struct($myparser, $response, $vals, $index);

  	if(!isset($index['ACCEPTSUBSCRIPTION']))  {
  	  header("Location: ".NODBPAGE);
      exit;
  	}

    $profile['id']              = $vals[$index['USER'][0]]['attributes']['ID'];
    $profile['FirstName']       = $vals[$index['FIRSTNAME'][0]]['value'];
    $profile['LastName']        = $vals[$index['LASTNAME'][0]]['value'];
    $profile['LoginName']       = $vals[$index['LOGINNAME'][0]]['value'];
    $profile['EmailAddress']    = $vals[$index['EMAILADDRESS'][0]]['value'];
    $profile['InstitutionName'] = $vals[$index['INSTITUTIONNAME'][0]]['value'];
    $profile['secret']          = SECRET;

    for($i=0;$i<count($index['MODULE']);$i+=2)  {
      if($vals[$index['MODULEABBREV'][($i/2)]]['value'] == SMSMODULEABBREV)  {
        $profile['isTrial']                       = $vals[$index['MODULE'][$i]]['attributes']['ISTRIAL'];
        $profile['isExpiringWithinWarningPeriod'] = $vals[$index['MODULE'][$i]]['attributes']['ISEXPIRINGWITHINWARNINGPERIOD'];
        $profile['isExpired']                     = $vals[$index['MODULE'][$i]]['attributes']['ISEXPIRED'];
        $profile['LastSignOnDate']                = $vals[$index['LASTSIGNONDATE'][($i/2)]]['value'];
        $profile['ExpirationDate']                = $vals[$index['EXPIRATIONDATE'][($i/2)]]['value'];
        $profile['ProductRoleName']               = $vals[$index['PRODUCTROLENAME'][($i/2)]]['value'];
      }
    }
    /* ------------------------------------------- */
    
    
    return $profile;
  }


  /* --------- Sets the profile cookie --------- */  
  function setProfileCookie($profile)  {
    $json = new Services_JSON();
    $cookiedata = $json->encode($profile);
    setCookie('ssoProfile', $cookiedata, 0, '/');
  }
  /* ------------------------------------------- */


  /* --------- Where to go after login --------- */  
  function nextPage($profile)  {
    if(!isset($profile['isExpired']))
      return UNAUTHMODULEPAGE;
    else if($profile['isExpired'] == 'true')
      return EXPIREDPAGE;
    else if($profile['isExpiringWithinWarningPeriod'] == 'true')
      if($profile['ProductRoleName'] == 'Educator')
        return EXPIRESOONPAGE."?nextURL=".urlencode(EDUCATORPAGE);
      else if($profile['ProductRoleName'] == 'Student')
        return EXPIRESOONPAGE."?nextURL=".urlencode(STUDENTPAGE);
      else  // Why?  Are there more types of people than Educators and Students?
        return EXPIRESOONPAGE."?nextURL=".urlencode(STUDENTPAGE);
    else if($profile['ProductRoleName'] == 'Educator')
      return EDUCATORPAGE;
    else if($profile['ProductRoleName'] == 'Student')
      return STUDENTPAGE;
    else  // Again, Why?
      return STUDENTPAGE;
  }
  /* ------------------------------------------- */
  
  
  /* --------- Verify cookie freshness --------- */  
  function verifySecret($cookie)  {
    if(isset($cookie))  {
      $json = new Services_JSON(SERVICES_JSON_LOOSE_TYPE);
      $profile = $json->decode(stripslashes($cookie));
      if($profile['secret'] == SECRET) return true;
    }
    return false;
  }
  /* ------------------------------------------- */
  
  
  /* ---- Check whether to protect this URI ---- */  
  function smsProtect($uri)  {
      return (eregi(NOPROTECT,$uri)) ? false : true;
  }
  /* ------------------------------------------- */


  /* ---- Check for restricted role access ----- */  
  function roleProtect($uri,$profile)  {
    if(eregi(EDUCATORPROTECT,$uri))  {
      if($profile['ProductRoleName'] != 'Educator')  {
        header("Location: ".UNAUTHROLEPAGE."?role=Educator");
        exit;
      }
    }
    if(eregi(STUDENTPROTECT,$uri))  {
      if($profile['ProductRoleName'] != 'Student')  {
        header("Location: ".UNAUTHROLEPAGE."?role=Student");
        exit;
      }
    }
  }
  /* ------------------------------------------- */
  
?>